<?php
require_once __DIR__ . '/../includes/admin_auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';

// Require authentication
if (!isAdminLoggedIn()) {
    sendErrorResponse('Unauthorized', 401);
}

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendErrorResponse('Invalid request method', 405);
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['video_id'])) {
    sendErrorResponse('Missing video_id parameter');
}

$videoId = $input['video_id'];

try {
    // Get video info before deleting
    $video = getVideoById($videoId);

    if (!$video) {
        sendErrorResponse('Video not found', 404);
    }

    // Delete from database (soft delete)
    if (!deleteVideo($videoId)) {
        throw new Exception('Failed to delete video from database');
    }

    // Optionally delete the physical file
    $filePath = UPLOAD_DIR . $video['filename'];
    if (file_exists($filePath)) {
        if (!unlink($filePath)) {
            error_log("Warning: Failed to delete video file: $filePath");
            // Don't fail the request, database deletion is more important
        }
    }

    // Permanently remove from database
    permanentlyDeleteVideo($videoId);

    // Log the deletion
    logMessage("Video deleted: $videoId ({$video['original_filename']}) by admin", 'info');

    // Return success response
    sendJSONResponse([
        'success' => true,
        'message' => 'Video deleted successfully'
    ]);

} catch (Exception $e) {
    error_log("Delete error: " . $e->getMessage());
    sendErrorResponse('Delete failed: ' . $e->getMessage(), 500);
}
?>
