<?php
/**
 * GET /api/video.php?id={video_id}
 * Returns single video details
 * Requires: X-API-Key header
 */

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';

// Set JSON header
header('Content-Type: application/json');

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendErrorResponse('Method not allowed', 405);
}

// Validate API key
requireAPIKey();

// Get video ID from query parameter
$videoId = $_GET['id'] ?? null;

if (!$videoId) {
    sendErrorResponse('Missing video ID parameter', 400);
}

try {
    // Get video from database
    $video = getVideoById($videoId);

    if (!$video) {
        sendErrorResponse('Video not found', 404);
    }

    // Format video for response
    $formattedVideo = [
        'id' => $video['video_id'],
        'filename' => $video['original_filename'],
        'aspect_ratio' => $video['aspect_ratio'],
        'url' => $video['url'],
        'file_size' => (string)$video['file_size'],
        'duration' => (int)$video['duration'],
        'upload_date' => $video['upload_date']
    ];

    // Send response
    sendJSONResponse([
        'success' => true,
        'video' => $formattedVideo
    ]);

} catch (Exception $e) {
    error_log("API Error (video.php): " . $e->getMessage());
    sendErrorResponse('Internal server error', 500);
}
?>
